=begin
Copyright (C) 2011 Simon Lehmayr <simon.lehmayr@gmx.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
=end

H2OFFS = 0x38e # fix bei H2 ZOOM
SROFFS = 0x37a # 4 byte
SWOFFS = 0x384 # 2 byte
puts "h2enc - converts 2 H2 ZOOM stereo waves into true surround 6ch wave. (c) 2011\nv1.4 by Simon [www.lehmayr.de]\n"
puts "front wave file:      "+ARGV[0]
ff = File.open(ARGV[0], "rb")
ff.seek(SROFFS)
samplerate = ff.read(4).unpack("V")[0]
ff.seek(SWOFFS)
samplewidth = ff.read(2).unpack("v")[0]
ff.seek(H2OFFS)
ffsize = File.size(ARGV[0])-H2OFFS
frname = ARGV[1]||ARGV[0].sub('F','R')
puts "rear wave file:       "+frname
fr = File.open(frname, "rb")
fr.seek(H2OFFS)
frsize = File.size(frname)-H2OFFS
if ffsize != frsize
    puts "fatal error: quadrophonic file sizes not equal!"
    abort
end
foname = ARGV[0].sub(/\.wav/i, "_6ch.wav")
puts "6ch output wave file: "+foname
fo = File.open(foname, "wb")
fosize = 0x3c+ffsize*3
puts "sample rate (Hz):     #{samplerate}\nsample width (bits):  #{samplewidth}"
hedr = "RIFF"+[fosize].pack("V")+"WAVEfmt \x28\x00\x00\x00\xfe\xff\x06\x00\x44\xac\x00\x00\x30\x13\x08\x00\x0c\x00\x10\x00\x16\x00\x10\x00\x3f\x00\x00\x00\x01\x00\x00\x00\x00\x00\x10\x00\x80\x00\x00\xaa\x00\x38\x9b\x71data" + [ffsize*3].pack("V")
hedr[0x18..0x1b] = [samplerate].pack("V")
blockalign = samplewidth*6/8
avgbytessec = blockalign*samplerate
hedr[0x1c..0x1f] = [avgbytessec].pack("V")
hedr[0x20..0x21] = [blockalign].pack("v")
hedr[0x22..0x23] = [samplewidth].pack("v")
hedr[0x26..0x27] = [samplewidth].pack("v")
fo.print hedr
swch = samplewidth/4
nsch = "\x00"*swch
puts "writing #{ffsize*3} bytes...\n\n0%---------------------50%--------------------100%"
curp = 0.0
s = ffsize*3
while !ff.eof
    fo.write ff.read(swch)
    fo.write nsch
    fo.write fr.read(swch)
    s -= blockalign
    realp = 100.0*(ffsize*3-s)/ffsize/3.0
    if realp > curp
        print ">"
        curp += 2.0
    end
end
puts "\ndone."
ff.close; fr.close; fo.close
